USE BMS_EIS	
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_GetTraitIENList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[fn_GetTraitIENList]
GO
CREATE FUNCTION [dbo].[fn_GetTraitIENList](@TEXT varchar(MAX), @DELIMITER varchar(20) = ' ', @VISTA_CODE NVARCHAR(20))
RETURNS VARCHAR(MAX)
AS
BEGIN
DECLARE @INDEX int, @IENsList VARCHAR(MAX)
SET @IENsList = NULL
SET @INDEX = -1
WHILE (LEN(@TEXT) > 0)
  BEGIN 
	SET @INDEX = CHARINDEX(@DELIMITER , @TEXT) 
  
	IF (@INDEX = 0) AND (LEN(@TEXT) > 0) 
	  BEGIN
		  IF CHARINDEX(@VISTA_CODE, @TEXT) = 0
			BEGIN
				IF @IENsList IS NULL
					SET @IENsList = @TEXT 
				ELSE
					SET @IENsList = @IENsList + '|' + @TEXT
			END
		  BREAK 
	  END 

	IF (@INDEX > 1) 
	  BEGIN 
		  IF CHARINDEX(@VISTA_CODE, LEFT(@TEXT, @INDEX - 1)) = 0
			BEGIN
				IF @IENsList IS NULL
					SET @IENsList = LEFT(@TEXT, @INDEX - 1)
				ELSE
					SET @IENsList = @IENsList  + '|' +  LEFT(@TEXT, @INDEX - 1) 
			END
		SET @TEXT = RIGHT(@TEXT, (LEN(@TEXT) - @INDEX)) 
	  END 
	ELSE
	  SET @TEXT = RIGHT(@TEXT, (LEN(@TEXT) - @INDEX))
	END
  RETURN @IENsList
END
GO

DECLARE @VISTA_CODE NVARCHAR(20), @VISTA_UID UNIQUEIDENTIFIER
BEGIN TRY
	BEGIN TRANSACTION;
		SET @VISTA_CODE = '$(varVISTACode)'

		SELECT @VISTA_UID = E.IDENTIFIER
		FROM ENTITY AS E
		INNER JOIN EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
		WHERE O.NAME = @VISTA_CODE AND CODE_CODE ='VST'

		CREATE TABLE #DEL_PATIENT(ID INT)
		CREATE TABLE #UPD_PATIENT(PK_TRAIT INT)
		INSERT INTO #UPD_PATIENT(PK_TRAIT)
		SELECT TV.PK_TRAIT_VALUE FROM TRAIT_VALUE AS TV
		INNER JOIN EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = TV.FK_ENTITY AND R.CLASS_CODE = 'PAT'
		INNER JOIN TRAIT_ASSIGNMENT_ENTITY_TYPE  AS TAET ON TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE
		INNER JOIN TRAIT AS T ON T.PK_TRAIT = TAET.FK_TRAIT
		WHERE T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%'+ @VISTA_CODE +'%' AND TV.TRAIT_VALUE_STRING LIKE '%|%'

		INSERT INTO #DEL_PATIENT(ID)
		SELECT P.PFK_PERSON FROM  EHL7_PERSON AS P
		INNER JOIN EHL7_ROLE AS R ON P.PFK_PERSON = R.FK_PLAYER_ENTITY AND R.CLASS_CODE = 'PAT'
		INNER JOIN TRAIT_VALUE AS TV ON TV.FK_ENTITY = P.PFK_PERSON
		INNER JOIN TRAIT_ASSIGNMENT_ENTITY_TYPE  AS TAET ON TAET.PK_TRAIT_ASSIGNMENT_ENTITY_TYPE = TV.FK_TRAIT_ASSIGNMENT_ENTITY_TYPE
		INNER JOIN TRAIT AS T ON T.PK_TRAIT = TAET.FK_TRAIT
		WHERE T.IDENTIFIER = 'IEN_LIST' AND TV.TRAIT_VALUE_STRING LIKE '%'+ @VISTA_CODE +'%' AND TV.TRAIT_VALUE_STRING NOT LIKE '%|%'
					
		--DELETE EHL7 ROLE PATIENT
		DELETE ROL_PAT FROM EHL7_ROLE_PATIENT AS ROL_PAT
		INNER JOIN EHL7_ROLE AS ROL ON ROL.PK_ROLE = ROL_PAT.PK_PATIENT
		INNER JOIN #DEL_PATIENT AS DEL ON DEL.ID = ROL.FK_PLAYER_ENTITY
		
		--DELETE ROLE
		DELETE ROL FROM EHL7_ROLE AS ROL
		INNER JOIN #DEL_PATIENT AS DEL ON DEL.ID = ROL.FK_PLAYER_ENTITY

		--DELETE TRAIT
		DELETE TV FROM TRAIT_VALUE AS TV
		INNER JOIN #DEL_PATIENT AS DEL ON DEL.ID = TV.FK_ENTITY
		
		--DELETE UID
		DELETE OUID FROM EHL7_UID AS OUID
		INNER JOIN #DEL_PATIENT AS DEL ON DEL.ID = OUID.FK_ENTITY

		--DELETE PERSON
		DELETE P FROM  EHL7_PERSON AS P
		INNER JOIN #DEL_PATIENT AS DEL ON DEL.ID = P.PFK_PERSON

		--DELETE ENTITY
		DELETE E FROM ENTITY AS E
		INNER JOIN #DEL_PATIENT AS DEL ON DEL.ID = E.PK_ENTITY

		DROP TABLE #DEL_PATIENT

		IF (SELECT COUNT(PK_TRAIT) FROM #UPD_PATIENT) > 0
		BEGIN
			UPDATE T
				SET T.TRAIT_VALUE_STRING = [dbo].[fn_GetTraitIENList](T.TRAIT_VALUE_STRING, '|', @VISTA_CODE)
			FROM TRAIT_VALUE AS T
			INNER JOIN #UPD_PATIENT AS UPD ON UPD.PK_TRAIT = T.PK_TRAIT_VALUE			
		END

		DROP TABLE #UPD_PATIENT
		IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_GetTraitIENList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
		DROP FUNCTION [dbo].[fn_GetTraitIENList]

		DELETE FROM BMS.dbo.VISTA_OPERATIONS WHERE VISTA_ID = @VISTA_UID AND OPERATION_ID = 2
	SELECT 'Patient - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;


